/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.util.RqsException;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.Socket;

public final class RqService
implements FcsService,
BaseRsfErrorIds {
    private static final String TRACE_MASKT = "XRSFRQST";
    private static final String TRACE_MASKF = "XRSFRQSF";
    private static final String TRACE_MASKD = "XRSFRQSD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RqService");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static FcsServer fcsServer = FcsServer.getFcsServer();
    public static FcsServiceId rqServiceId = new FcsServiceId("RqService", 1.0);
    private static RqService rql = new RqService();
    private static String METHOD_SEPARATOR = " ";
    public static String RC_EXEC_RETURNED_VOID = "Execute completed, no return";
    public static String RC_INVALID_SYNTAX = "Invalid syntax for exec";
    public static String RC_CLASS_NOT_FOUND = "Class not found at target";
    public static String RC_METHOD_NOT_FOUND = "Method not found at target";
    public static String RC_CLASS_NOT_CONSTRUCTED = "Class does not contain null constructor for non-static method";
    public static String RC_METHOD_INVOKE_ERROR = "Error invoking method";

    public static RqService getRqService() {
        return rql;
    }

    private RqService() {
        fcsServer.addLocalService(rqServiceId, this);
    }

    public String queryFileLocation(String filename, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::queryFileLocation()");
        String result = (String)this.query("find " + filename, target);
        Trace.trace(TRACE_MASKT, "<- RqService::queryFileLocation(): result=" + result);
        return result;
    }

    public Object executeProgram(String className, String methodName, Object parms, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::executeProgram()");
        Object result = this.query("exec " + className + METHOD_SEPARATOR + methodName, parms, target);
        Trace.trace(TRACE_MASKT, "<- RqService::executeProgram(): result=" + result);
        return result;
    }

    private Object query(String queryString, MachineId target) throws RqsException {
        return this.query(queryString, null, target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object query(String queryString, Object parms, MachineId target) throws RqsException {
        Trace.trace(TRACE_MASKT, "-> RqService::query() " + queryString);
        if (parms != null && !(parms instanceof Serializable)) {
            throw new RqsException("RqService parms must implement Serializable");
        }
        Socket socket = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        Object reply = null;
        String targetInfo = this.machineInfo(target);
        Trace.trace(TRACE_MASKD, "-> RqService.query: targetInfo=" + targetInfo);
        try {
            try {
                FcsConnection connection = FcsConnection.connect(target, rqServiceId);
                socket = connection.getSocket();
                Trace.trace(TRACE_MASKF, "RqService.query: writing initial String '" + queryString + "'");
                oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                oos.writeObject(queryString);
                if (parms != null) {
                    Trace.trace(TRACE_MASKF, "RqService.query: writing parms");
                    oos.writeObject(parms);
                }
                oos.flush();
                ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                Trace.trace(TRACE_MASKF, "RqService.query: reading results");
                reply = ois.readObject();
                Trace.trace(TRACE_MASKF, "RqService.query reply=" + reply);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "RqService.query Exception: " + e.getMessage());
                Trace.trace(TRACE_MASKF, e);
                throw new RqsException(e.getMessage());
            }
            Object var11_11 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois == null) throw throwable;
                ois.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (oos != null) {
            oos.close();
        }
        if (ois != null) {
            ois.close();
        }
        Trace.trace(TRACE_MASKT, "<- RqService::query()");
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processConnection(FcsConnection connection) {
        block27: {
            MachineId sender2 = connection.getMachineId();
            String senderInfo = this.machineInfo(sender2);
            Trace.trace(TRACE_MASKT, "-> RqService.processConnection() " + senderInfo);
            ObjectInputStream ois = null;
            ObjectOutputStream oos = null;
            Socket socket = connection.getSocket();
            String request = null;
            String query = null;
            String parms = "";
            Object response = null;
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            Trace.trace(TRACE_MASKF, "RqService.process connection: reading query string");
            request = (String)ois.readObject();
            if (request == null) {
                throw new RqsException("No data received from sending machine");
            }
            request = request.trim();
            Trace.trace(TRACE_MASKF, "RqService: process connection  request=" + request);
            int commandSeparator = request.indexOf(" ");
            if (commandSeparator == -1) {
                query = request;
            } else {
                query = request.substring(0, commandSeparator);
                parms = request.substring(commandSeparator).trim();
            }
            if (query.equalsIgnoreCase("find")) {
                try {
                    response = BaseFileControl.getFilePath(parms);
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection() getFilePath exception");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else if (query.equalsIgnoreCase("exec")) {
                Trace.trace(TRACE_MASKF, "RqService.processConnection: exec - now try to read parms");
                Object arg = null;
                try {
                    arg = ois.readObject();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection: exception trying to read object for exec parms:  This may be a normal condition.");
                    Trace.trace(TRACE_MASKF, e);
                }
                Trace.trace(TRACE_MASKF, "RqService.processConnection arg=" + arg);
                parms = parms.trim();
                int methodSeparator = parms.indexOf(METHOD_SEPARATOR);
                if (methodSeparator < 1 || methodSeparator + 1 == parms.length()) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection exec: parms error=" + parms);
                    response = RC_INVALID_SYNTAX;
                } else {
                    response = RqService.executeLocalMethod(parms.substring(0, methodSeparator), parms.substring(methodSeparator + 1), arg);
                }
            } else {
                Trace.trace(TRACE_MASKF, "RqService.processConnection: function not implemented \"" + request + "\"");
            }
            Trace.trace(TRACE_MASKF, "RqService.processConnection: response=" + response);
            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            oos.writeObject(response);
            oos.flush();
            Object var15_17 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
                break block27;
            }
            catch (IOException ioe) {}
            break block27;
            {
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "RqService.processConnection Exception");
                    Trace.trace(TRACE_MASKF, e);
                    Object var15_18 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        if (ois != null) {
                            ois.close();
                        }
                        break block27;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RqService.processConnection()");
    }

    public static Object executeLocalMethod(String className, String methodName, Object arg) {
        Object returnVal;
        Method implMethod;
        Class<?> implClass;
        Trace.trace(TRACE_MASKT, "-> RqService::executeLocalMethod() for " + className + " " + methodName);
        Trace.trace(TRACE_MASKT, "RqService.executeLocalMethod with parms=" + arg);
        try {
            implClass = Class.forName(className);
        }
        catch (Exception e) {
            return RC_CLASS_NOT_FOUND;
        }
        Class[] parmClass = null;
        Object[] args = null;
        if (arg != null) {
            parmClass = new Class[]{arg.getClass()};
            args = new Object[]{arg};
        }
        try {
            implMethod = implClass.getDeclaredMethod(methodName, parmClass);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "RqService.executeLocalMethod: method not found");
            Trace.trace(TRACE_MASKF, e);
            return RC_METHOD_NOT_FOUND;
        }
        try {
            if (Modifier.isStatic(implMethod.getModifiers())) {
                returnVal = implMethod.invoke(null, args);
            } else {
                Object classObj = implClass.newInstance();
                returnVal = implMethod.invoke(classObj, args);
            }
        }
        catch (InstantiationException e) {
            RqService.logInfo("RqService.executeLocalMethod exception", e);
            returnVal = RC_CLASS_NOT_CONSTRUCTED;
        }
        catch (Exception e) {
            RqService.logInfo("RqService.executeLocalMethod exception", e);
            returnVal = RC_METHOD_INVOKE_ERROR;
        }
        if (returnVal == null) {
            Trace.trace(TRACE_MASKF, "RqService.executeLocalMethod : no return value");
            returnVal = RC_EXEC_RETURNED_VOID;
        }
        Trace.trace(TRACE_MASKT, "<- RqService.executeLocalMethod() Ok");
        return returnVal;
    }

    private String machineInfo(MachineId machine) {
        InetAddress[] nicAddresses = machine.getNicAddresses();
        return machine.getName() + "(" + nicAddresses[0] + ")";
    }

    private static void logInfo(String msg, Throwable t) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, 12803, t) : new FrameworkLog(logInfo, 12803);
        errLog.add(msg);
        errLog.log(infoLog);
    }
}

